//	CDiskImagePro.h

#ifndef _H_CDiskImagePro
#define _H_CDiskImagePro

#include "CDisk.h"
#include "ProStructs.h"

class CDesktop;

typedef	OSErr	(*ForEachBitmapBlockCB)(
	CDiskPro		*thiz, 
	Pro_BlockNum	block, 
	Boolean			*free, 
	Boolean			*done, 
	void			*data
);

typedef struct {
	//	if i'm the owner I must dispose, else I actually point to someone
	//	lower on the stack, so do NOT dispose
	Boolean			ownerB;
	Pro_Block		*blockBuf;
	Pro_BlockNum	recentBlockNum;
} Pro_BlockStackNode;

//	biggest vbitmap is 16, plus 6 for caches
#define			kPro_BlockStackSize		(16L + 6L)

class CDiskPro : public CDisk {

	public:
	
	OSErr		IDiskPro(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec
	);

	virtual		void		Dispose(void);
	
	virtual	void			Dismount(void);

	virtual	OSErr			BuildFileTypeMenu(void);
	virtual	short			MenuItemToFileType(short menuItem, ushort *auxType);
	virtual	short			FileTypeToMenuItem(Byte fileType, short auxType);
	
	virtual	char			*GetName(char *buf);
	virtual	OSErr			SetGenericBlock(ushort blockNumS, Gen_Block *blockP);
	virtual	OSErr			GetGenericBlock(ushort blockNumS, Gen_Block **blockP);
	virtual	OSErr			GetBlock(Pro_BlockNum blockNum, Pro_Block **blockP);
	virtual	OSErr			SetBlock(void);
	virtual	char			*GetDescription(char *buf);
	virtual	ulong			GetVolumeSize(void);
	virtual ADFS_IconType	GetIconType(void);

	OSErr			GetBitMapBlocksNum(
		Pro_BlockNum *startBlockS, 
		Pro_BlockNum *lastBlockS, 
		ulong		 *blocksInVolumeL0);

	OSErr		GetUnAllocBlocks(
		Boolean			getAsBlocksB, 
		Boolean			mysteryB, 
		Pro_BlockNum	*maxEmptyS, 
		Pro_BlockNum	*blockListA);

	virtual	OSErr			GetEntryAlloc(
		Boolean				getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	virtual	void			GetAccessBits(Gen_AccessBits *bits);
	virtual	void			SetAccessBits(Gen_AccessBits *bits);

	virtual	OSErr		FlushMemDisk(Boolean flushB);

			OSErr			ForEachBitmapBlock(
				ForEachBitmapBlockCB	ForEachBitmapBlockUserCB, 
				void					*data
			);
			
			OSErr			IsBlockFree(Pro_BlockNum test_block, Boolean *is_freeBP);
			OSErr			GetFreeBlock(Pro_BlockNum *freeBlock);
			OSErr			FreeBlock(Pro_BlockNum block);
			OSErr			ReserveBlock(Pro_BlockNum block);
			OSErr			ReserveNextFreeBlock(Pro_BlockNum *freeBlock);
			ulong			GetVolumeBytesUsed(void);
			ulong			GetVolumeMaxFileSize(ushort pro_fileTypeS);
			ulong			CalcBytesUsedByFile(ulong fileSize);

			OSErr			FlushEntry(void);
			Pro_DirHeader	*GetMyEntry(void);
	virtual	DateTimeRec		*GetCreatedTime(DateTimeRec *dt);
	virtual	DateTimeRec		*GetModifiedTime(DateTimeRec *dt);
	virtual	void			SetCreatedTime(DateTimeRec *dt);
	virtual	void			SetModifiedTime(DateTimeRec *dt);

	virtual	void			SetName(char *buf);
	virtual	OSErr			ZeroUnused(void);
	virtual	Boolean			SupportsForks(void);
	virtual	Boolean			IsLocked(void);
	virtual	OSErr			NewDisk_Completion(ADFS_NewDiskCompletionRec *recP);
	
	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);

	OSErr		CacheBitmapBlocks(void);
	OSErr		UnCacheBitmapBlocks(void);
	OSErr		PushBlock(void);
	OSErr		PopBlock(void);
	
	OSErr		ExpandToSize(long bytesOnDiskL);
	ushort		GetSectorsPerBlock(void);
	ushort		GetBlocksPerTrack(void);

	Boolean		IsDeletedEntry(
		Pro_DirEntry *entryP, 
		ulong		 blocksInVolumeL, 
		Pro_BlockNum headerBlockS);

	Boolean		IsValidEntry(
		Pro_DirEntry *entryP, 
		ulong		 blocksInVolumeL, 
		Pro_BlockNum headerBlockS);

	void		AddIconFile(CFilePro *fileP);
	Boolean		HasCustomIcon(ushort fileType, ushort auxType, char *nameZ);
	Handle		GetCustomIcon(ushort fileType, ushort auxType, char *nameZ);
	OSErr		UpdateVolDirVers(void);

	void		DumpDisk(void);

	void		UpdateMenus(void);
	Boolean		DoCommand(long command);

	/****************************************************/
	Pro_DirHeader	i_myEntry;

	Handle			i_iconH;

	//	the following 2 == index 0 of the block stack
	Pro_Block		*i_blockBuf;
	Pro_BlockNum	i_recentBlockNum;		//	from most recent GetBlock
	
	//	stack of recent blocks.
	short					i_blockStackIndex;
	Pro_BlockStackNode		i_blockStackA[kPro_BlockStackSize];
	
	//	see CacheBitmapBlocks
	short				i_cachedBitmapBlocksRefCountS;
	short				i_cachedBitmapBlocks;

	private:
	typedef CDisk		_inherited;
};



#endif
